<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#assign deCodeNameCamel = srfcaseformat(de.codeName,'l_u2lC')?cap_first>
<#comment>实体是否配置预置属性</#comment>
<#assign hasDEPrefield=false>
<#if de.getPSDEFieldByPDT('ORGID',true)?? || de.getPSDEFieldByPDT('ORGSECTORID',true)??  || de.getPSDEFieldByPDT('CREATEMAN',true)?? >
    <#assign hasDEPrefield=true>
</#if>
<#assign hasDEImport=false>
<#comment>实体数据导入</#comment>
<#if de.getAllPSDEDataImports?? && de.getAllPSDEDataImports()??>
    <#list de.getAllPSDEDataImports() as deImport>
        <#assign hasDEImport=true>
        <#break>
    </#list>
</#if>
<#if de.getStorageMode()==1 || de.getStorageMode()==2 ||de.getStorageMode()==4||de.getStorageMode()==0>
package ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()};
import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.filter.${de.getCodeName()}SearchContext;

<#comment>SQL存储-Mybatis</#comment>
<#if de.getStorageMode()==1>

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[${item.codeName}] 服务对象接口
 */
public interface I${item.codeName}Service extends IService<${item.codeName}>{

    <@addIDESerivceBody />
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =${r'#{et.param}'}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =${r'#{et.param}'}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    <#if hasDEPrefield>
    List<${de.codeName}> get${deCodeNameCamel}ByIds(List<String> ids) ;
    List<${de.codeName}> get${deCodeNameCamel}ByEntities(List<${de.codeName}> entities) ;
    </#if>
}
<#comment>NoSQL存储-MongoDB</#comment>
<#elseif de.getStorageMode()==2>

/**
 * 实体[${item.codeName}] 服务对象接口
 */
public interface I${item.codeName}Service{

    <@addIDESerivceBody />

    <#if hasDEPrefield>
    List<${de.codeName}> get${deCodeNameCamel}ByIds(List<String> ids) ;
    List<${de.codeName}> get${deCodeNameCamel}ByEntities(List<${de.codeName}> entities) ;
    </#if>
}

<#elseif de.getStorageMode()==4>

/**
 * 实体[${item.codeName}] 服务对象接口
 */
public interface I${item.codeName}Service{

    <@addIDESerivceBody />

}

<#elseif de.getStorageMode()==0>

/**
 * 实体[${item.codeName}] 服务对象接口
 */
public interface I${item.codeName}Service{

    <@addIDESerivceBody />

}

</#if>

<#macro addIDESerivceBody >
<#comment>实体接口主体内容</#comment>
    <#assign keyfield=item.getKeyPSDEField()>
    <#if item.getAllPSDEActions()??>
        <#list item.getAllPSDEActions() as deaction>
            <#if deaction.isEnableBackend()>
                <#if (deaction.getActionType()=='USERCUSTOM') >
    ${item.codeName} ${srfmethodname(deaction.getCodeName())}(${item.codeName} et) ;
                <#elseif deaction.getActionType()=='DELOGIC'>
    ${item.codeName} ${srfmethodname(deaction.getCodeName())}(${item.codeName} et) ;
                <#elseif deaction.codeName?lower_case == 'get'>
    ${item.codeName} get(${srfr7javatype(keyfield.stdDataType)} key) ;
                <#elseif deaction.codeName?lower_case == "create">
    boolean create(${item.codeName} et) ;
    <#if item.isEnableEntityCache()==true>
    @CacheEvict(value="${item.codeName?lower_case}",allEntries=true)
    </#if>
    void createBatch(List<${item.codeName}> list) ;
                <#elseif deaction.codeName?lower_case == "update">
    boolean update(${item.codeName} et) ;
    <#if item.isEnableEntityCache()==true>
    @CacheEvict(value="${item.codeName?lower_case}",allEntries=true)
    </#if>
    void updateBatch(List<${item.codeName}> list) ;
                <#elseif deaction.codeName?lower_case == "remove">
    boolean remove(${srfr7javatype(keyfield.stdDataType)} key) ;
    <#if item.isEnableEntityCache()==true>
    @CacheEvict(value="${item.codeName?lower_case}",allEntries=true)
    </#if>
    void removeBatch(Collection<${srfr7javatype(keyfield.stdDataType)}> idList) ;
                <#elseif deaction.codeName?lower_case == "save">
    boolean save(${item.codeName} et) ;
    <#if item.isEnableEntityCache()==true>
    @CacheEvict(value="${item.codeName?lower_case}",allEntries=true)
    </#if>
    void saveBatch(List<${item.codeName}> list) ;
                <#elseif deaction.codeName?lower_case == "getdraft">
    ${item.codeName} getDraft(${item.codeName} et) ;
                <#elseif deaction.codeName?lower_case == "checkkey">
    boolean checkKey(${item.codeName} et) ;
                <#elseif deaction.codeName?lower_case == "createbatch">
                <#elseif deaction.codeName?lower_case == "savebatch">
                <#elseif deaction.codeName?lower_case == "updatebatch">
                <#elseif deaction.codeName?lower_case == "removebatch">
                <#else>
    ${item.codeName} ${srfmethodname(deaction.getCodeName())}(${item.codeName} et) ;
                </#if>
    <@outputTestActionDetail deaction />
            </#if>
        </#list>
    </#if>
    <#if item.getAllPSDEDataSets()??>
        <#list item.getAllPSDEDataSets() as dedataset>
    Page<<#if dedataset.isEnableGroup()>HashMap<#else>${item.getCodeName()}</#if>> search${dedataset.getCodeName()}(${item.codeName}SearchContext context) ;
        </#list>
    </#if>
    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
    List<${item.getCodeName()}> selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfr7javatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) ;
    <#if item.isEnableEntityCache()==true>
    @CacheEvict(value="${item.codeName?lower_case}",allEntries=true)
    </#if>
    void removeBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfr7javatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case}) ;
	                                <#assign nested=MinorPSDER.isNestedRS()>
                                    <#if nested == false && MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                                        <#list MinorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                            <#if api.isNested()>
                                                <#assign nested=true>
                                            </#if>
                                        </#list>
                                    </#if>
                                    <#if nested>
    <#if item.isEnableEntityCache()==true>
    @CacheEvict(value="${item.codeName?lower_case}",allEntries=true)
    </#if>
    void saveBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}(${srfr7javatype(MajorField.stdDataType)} ${MajorkeyField.codeName?lower_case},List<${item.getCodeName()}> list) ;
                                    </#if>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>
    <#comment>实体数据导入</#comment>
    <#if hasDEImport>
    JSONObject importData(List<${de.codeName}> entities,int batchSize,boolean isIgnoreError);

    @Async("asyncExecutor")
    void asyncImportData(List<${de.codeName}> entities,int batchSize,boolean isIgnoreError);
    </#if>
</#macro>

<#comment>输出测试行为</#comment>
<#macro outputTestActionDetail deaction>
    <#if deaction.getTestActionMode?? && deaction.getTestActionMode()??  &&  (deaction.getTestActionMode() ==1 ||deaction.getTestActionMode() ==3) >
        <#if (deaction.getActionType()=='USERCUSTOM')>
    boolean test${srfmethodname(deaction.getCodeName())?cap_first}(${item.getCodeName()} et);
        <#elseif deaction.getActionType()=='DELOGIC'>
    boolean test${srfmethodname(deaction.getCodeName())?cap_first}(${item.getCodeName()} et);
        <#elseif deaction.getCodeName()?lower_case == 'get'>
    boolean testGet(${srfr7javatype(keyfield.stdDataType)} key);
        <#elseif deaction.getCodeName()?lower_case == "createbatch">
        <#elseif deaction.getCodeName()?lower_case == "updatebatch">
        <#elseif deaction.getCodeName()?lower_case == "removebatch">
        <#elseif deaction.getCodeName()?lower_case == "savebatch">
        <#elseif deaction.getCodeName()?lower_case == "create">
    boolean testCreate(${item.getCodeName()} et);
    boolean testCreateBatch(List<${item.getCodeName()}> list);
        <#elseif deaction.getCodeName()?lower_case == "update">
    boolean testUpdate(${item.getCodeName()} et);
    boolean testUpdateBatch(List<${item.getCodeName()}> list);
        <#elseif deaction.getCodeName()?lower_case == "save">
    boolean testSave(${item.getCodeName()} et);
    boolean testSaveOrUpdate(${item.getCodeName()} et);
    boolean testSaveBatch(Collection<${item.getCodeName()}> list);
    boolean testSaveBatch(List<${item.getCodeName()}> list);
        <#elseif deaction.getCodeName()?lower_case == "remove">
    boolean testRemove(${srfr7javatype(keyfield.stdDataType)} key);
    boolean testRemoveBatch(Collection<${srfr7javatype(keyfield.stdDataType)}> idList);
        <#elseif deaction.getCodeName()?lower_case == "getdraft">
    boolean testGetDraft(${item.getCodeName()} et);

        <#elseif deaction.getCodeName()?lower_case == "checkkey">
    boolean testCheckKey(${item.getCodeName()} et);
        <#else>
    boolean test${srfmethodname(deaction.getCodeName())?cap_first}(${item.getCodeName()} et);
        </#if>
    </#if>
</#macro>

</#if>